/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.demos.driver;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.driver.common.SetupMode;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.exception.ExceptionHandler;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.driver.oui.ConfigHelper;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.OUIInstallDriver;
import oracle.install.driver.oui.RootScriptJob;
import oracle.install.driver.oui.SessionDetails;
import oracle.install.driver.oui.SetupJob;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.bean.OracleHomeType;
import oracle.install.ivw.common.resource.AutoUpdatesManagerException;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.ivw.common.util.autoupdates.ApplyUpdatesJob;
import oracle.install.ivw.common.util.autoupdates.AutoUpdatesExceptionHandler;
import oracle.install.ivw.common.util.autoupdates.PostApplyUpdatesJob;
import oracle.install.ivw.common.util.autoupdates.PreApplyUpdatesJob;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.ivw.common.util.autoupdates.UpdatesHelper;
import oracle.install.ivw.demos.bean.DemosInstallSettings;
import oracle.install.ivw.demos.bean.DemosSetupBean;
import oracle.install.ivw.demos.resource.DemosDialogLabelResID;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.PlatformInfo;

public class DemosSetupDriver
extends OUIInstallDriver<DemosSetupBean> {
    private static final String OUI_VAR_MAPPING_FILE = "/oracle/install/ivw/demos/resource/demosoui_map.properties";
    private static Logger logger = Logger.getLogger(DemosSetupDriver.class.getName());
    DemosInstallSettings installSettings;

    public DemosSetupDriver() {
        this.setupBean = new DemosSetupBean();
    }

    public DemosSetupBean getSetupBean() {
        return (DemosSetupBean)((Object)this.setupBean);
    }

    public void load() throws SetupDriverException {
        super.load();
        ExceptionManager.getInstance().addExceptionHandler(AutoUpdatesManagerException.class, (ExceptionHandler)new AutoUpdatesExceptionHandler());
        boolean invFound = false;
        InventoryInfo invInfo = InventoryInfo.getInstance();
        invFound = invInfo.isInventoryExist();
        this.installSettings = ((DemosSetupBean)((Object)this.setupBean)).getDemosInstallSettings();
        CentralInventorySettings cenInv = ((DemosSetupBean)((Object)this.setupBean)).getCentralInventory();
        logger.log(Level.INFO, "Inventory exists: " + invFound);
        if (invFound) {
            cenInv.setGroupOwnership(invInfo.getUnixGroupName());
        }
        this.installSettings.setProductDescriptorLocation(System.getProperty("oracle.installer.sourceLoc"));
        String hostName = PlatformInfo.getInstance().getFullHostName();
        ((DemosSetupBean)((Object)this.setupBean)).setOracleHostName(hostName);
        try {
            String absPath = new File(System.getProperty("oracle.installer.sourceLoc")).getAbsolutePath();
            String parentDir = new File(absPath).getParent();
            String destLoc = System.getProperty("oracle.installer.scratchPath");
        }
        catch (Exception e) {
            throw new SetupDriverException((Throwable)e);
        }
    }

    protected CompositeJob prepareJob() throws SetupDriverException {
        CompositeJob installJob = new CompositeJob();
        DemosSetupJob demosSetupJob = null;
        boolean multinodeSetup = false;
        logger.log(Level.INFO, "Is multi node install {0}", multinodeSetup);
        demosSetupJob = new DemosSetupJob(multinodeSetup);
        installJob.add((Job)demosSetupJob);
        InventoryInfo inventoryInfo = InventoryInfo.getInstance();
        if (!inventoryInfo.isInventoryExist()) {
            String inventoryLocation = ((DemosSetupBean)((Object)this.setupBean)).getCentralInventory().getInventoryLocation();
            RootScriptJob.InventoryFilter filter = new RootScriptJob.InventoryFilter(inventoryLocation);
            RootScriptJob rootScriptJob = new RootScriptJob((SetupJob)demosSetupJob, (RootScriptJob.Filter)filter);
            Application application = Application.getInstance();
            rootScriptJob.setDescription(application.getString(ResourceURL.resURL((String)DriverConstants.STRING_RESOURCE_BUNDLE_NAME, (String)"inventoryRootScriptJob.text"), "Execute Inventory Root Scripts for {0}", new Object[]{demosSetupJob.getDescription()}));
            if (!PlatformInfo.getInstance().isWindows()) {
                Application.getInstance();
                if (!Application.isCommandLineSwitchEnabled((String)"-suppressRootMessage")) {
                    installJob.add((Job)rootScriptJob);
                }
            }
        }
        if (((DemosSetupBean)((Object)this.setupBean)).getAutoUpdatesInstallSettings().isApplyUpdates()) {
            PostApplyUpdatesJob postApplyUpdatesJob;
            ApplyUpdatesJob applyUpdatesJob;
            String downloadLocation = ((DemosSetupBean)((Object)this.setupBean)).getAutoUpdatesInstallSettings().getPatchDownloadLocation();
            String[] nodes = ((DemosSetupBean)((Object)this.setupBean)).getDemosInstallSettings().getListOfSelectedNodes();
            HashMap hashMap = demosSetupJob.getSessionDetails().getVariableMap();
            PreApplyUpdatesJob preApplyUpdatesJob = UpdatesHelper.getInstance().addPreApplyUpdatesJob(downloadLocation, hashMap, nodes);
            if (preApplyUpdatesJob != null) {
                installJob.add((Job)preApplyUpdatesJob);
            }
            if ((applyUpdatesJob = this.addApplyUpdatesJob(demosSetupJob.getSessionDetails().getVariableMap())) != null) {
                installJob.add((Job)applyUpdatesJob);
            }
            if ((postApplyUpdatesJob = UpdatesHelper.getInstance().addPostApplyUpdatesJob(downloadLocation, hashMap, nodes)) != null) {
                installJob.add((Job)postApplyUpdatesJob);
            }
        }
        return installJob;
    }

    private ApplyUpdatesJob addApplyUpdatesJob(HashMap sessionHashMap) {
        String[] allNodes;
        ApplyUpdatesJob applyUpdatesJob = null;
        HashMap newSessionHashMap = sessionHashMap;
        AutoUpdatesInstallSettings autoUpdatesSettings = ((DemosSetupBean)((Object)this.setupBean)).getAutoUpdatesInstallSettings();
        boolean applyAutoUpdates = autoUpdatesSettings.isApplyUpdates();
        logger.log(Level.FINEST, "In DemosSetupDriver: Applyautoupdates: " + applyAutoUpdates + " SetupMode: " + this.getSetupMode() + " downloadtype: " + autoUpdatesSettings.getDownloadType() + " Patch download location " + autoUpdatesSettings.getPatchDownloadLocation());
        String[] nodes = ((DemosSetupBean)((Object)this.setupBean)).getDemosInstallSettings().getListOfSelectedNodes();
        if (nodes != null && nodes.length > 0 && (allNodes = ((DemosSetupBean)((Object)this.setupBean)).getDemosInstallSettings().getListOfSelectedNodes()) != null && allNodes.length > 1) {
            String[] remoteNodes = new String[allNodes.length - 1];
            int i = 0;
            for (String node : allNodes) {
                if (MachineInfo.getInstance().getFullHostName().equalsIgnoreCase(node) || MachineInfo.getInstance().getLocalMachineName().equalsIgnoreCase(node)) continue;
                remoteNodes[i++] = node;
            }
            logger.log(Level.INFO, "REMOTE_NODES session variable added for applying updates");
            newSessionHashMap.put("REMOTE_NODES", remoteNodes);
        }
        if (applyAutoUpdates || this.getSetupMode() == SetupMode.SILENT && autoUpdatesSettings.getDownloadType() != PatchDownloadType.SKIP_UPDATES) {
            ArrayList cpuUpdatesList;
            UpdateManager updateManager = UpdateManager.getInstance();
            ArrayList allPatchesToBeApplied = new ArrayList();
            ArrayList oneOffsList = updateManager.getOneOffList();
            if (oneOffsList != null && oneOffsList.size() > 0) {
                allPatchesToBeApplied.addAll(updateManager.getOneOffList());
            }
            if ((cpuUpdatesList = updateManager.getAllCPU()) != null && cpuUpdatesList.size() > 0) {
                allPatchesToBeApplied.addAll(cpuUpdatesList);
            }
            if (allPatchesToBeApplied != null && allPatchesToBeApplied.size() > 0 || updateManager.getOPatchUpdate() != null && updateManager.getOPatchUpdate().getPatchBugNumber() != -1) {
                applyUpdatesJob = new ApplyUpdatesJob(allPatchesToBeApplied, newSessionHashMap);
                applyUpdatesJob.setRetryEnabled(true);
                if (autoUpdatesSettings.getPatchDownloadLocation() != null && autoUpdatesSettings.getPatchDownloadLocation().length() > 0) {
                    applyUpdatesJob.setDownloadLoc(autoUpdatesSettings.getPatchDownloadLocation());
                }
            }
        }
        return applyUpdatesJob;
    }

    private SessionDetails getDemosDetails(boolean multinodeSetup) throws SetupDriverException {
        SessionDetails sessionDetails = null;
        try {
            HashMap source = new HashMap();
            DemosInstallSettings demosSettings = ((DemosSetupBean)((Object)this.setupBean)).getDemosInstallSettings();
            BeanStoreUtils.storeAsStringMap(source, (Object[])new Object[]{demosSettings, ((DemosSetupBean)((Object)this.setupBean)).getCentralInventory()});
            BeanStoreUtils.storeAsXML((File)new File("/tmp/demos.xml"), (Object[])new Object[]{demosSettings, ((DemosSetupBean)((Object)this.setupBean)).getCentralInventory()});
            HashMap submitDemosMap = DriverHelper.transform(source, (String)OUI_VAR_MAPPING_FILE);
            ConfigHelper.populateConfigMap((Map)submitDemosMap);
            String version = InstallConstants.VERSION.toString();
            submitDemosMap.put("TOPLEVEL_COMPONENT", new String[]{"oracle.companionCD.db", version});
            submitDemosMap.put("COMPONENT_LANGUAGES", ((DemosSetupBean)((Object)this.setupBean)).getLanguages());
            submitDemosMap.put("SELECTED_LANGUAGES", ((DemosSetupBean)((Object)this.setupBean)).getLanguages());
            submitDemosMap.put("CLUSTER_NODES", demosSettings.getListOfSelectedNodes());
            if (InventoryInfo.getInstance().isInventoryExist()) {
                logger.info("Removing Inventory location and unix group name oui property from the submitHashmap as inventory is already available on the system");
                submitDemosMap.remove("INVENTORY_LOCATION");
                submitDemosMap.remove("UNIX_GROUP_NAME");
            }
            submitDemosMap.put("oracle_install_HomeType", OracleHomeType.Database.toString());
            submitDemosMap.put("oracle_install_ClientHomeType", OracleHomeType.Client.toString());
            String globalPropLocation = System.getProperty("oracle.installer.startup_location");
            logger.log(Level.INFO, "globalPropLocation CURRENT= " + globalPropLocation);
            globalPropLocation = globalPropLocation + "/../stage/globalvariables/globalvar.xml";
            System.setProperty("oracle.install.tb.globalvarpath", globalPropLocation);
            logger.log(Level.INFO, "globalpropLocation= " + globalPropLocation);
            logger.log(Level.INFO, "oracle.install.tb.globalvarpath= " + System.getProperty("oracle.install.tb.globalvarpath"));
            logger.log(Level.INFO, "Setting value of oracle.installer.force to true to prevent OUI to perform valilddations on the Summary page");
            System.setProperty("oracle.installer.force", "true");
            logger.log(Level.INFO, "VALUE of oracle.installer.force=" + System.getProperty("oracle.installer.force"));
            if (PlatformInfo.getInstance().isWindows()) {
                System.setProperty("oracle.installer.skipACLSetting", "true");
                logger.log(Level.INFO, "oracle.installer.skipACLSetting= " + System.getProperty("oracle.installer.skipACLSetting"));
            }
            sessionDetails = new SessionDetails("demos", submitDemosMap);
        }
        catch (Exception e) {
            throw new SetupDriverException((Throwable)e);
        }
        return sessionDetails;
    }

    class DemosSetupJob
    extends SetupJob {
        public DemosSetupJob() throws SetupDriverException {
            this(false);
        }

        public DemosSetupJob(boolean multinodeSetup) throws SetupDriverException {
            super((Object)"InstallDemos", Application.getInstance().getString(ResourceURL.resURL((String)DemosDialogLabelResID.class.getName(), (String)"setup.description"), "Oracle Examples Installation", new Object[0]), 0.8f, DemosSetupDriver.this.getDemosDetails(multinodeSetup), multinodeSetup);
        }
    }
}

